# Simply Love (ITGmania)

![Arrow Logo](https://i.imgur.com/oZmxyGo.png)


## About

Simply Love is an ITGmania theme for the post-ITG community.

It features a clean and simple design, offers numerous data-driven features not implemented by the ITGmania engine, and allows the current generation of ITG fans to breathe new life into the game they've known for over a two decades.

Simply Love was originally designed and implemented for a previous version of StepMania (SM3.95) by hurtpiggypig.  For more information on that version of Simply Love, check here:
https://www.youtube.com/watch?v=OtcWy5m6-CQ


## Supported Versions of ITGmania

The current release of Simply Love is compatible with current ITGmania versions **0.8.0** or newer.

For new installations we currently recommend grabbing the ITGmania + Simply Love bundle over at the
[www.itgmania.com](https://www.itgmania.com).


**Incompatible Versions**<br>
❌ StepMania 5 (SM5)<br>
❌ Forks of SM5 (e.g. *starworlds*)<br>
❌ Older versions of StepMania (e.g. StepMania 3.9)<br>
❌ Forks of older versions of StepMania (e.g. OpenITG, NotITG)<br>
❌ SM5.2


## Installing Simply Love

If you are upgrading from a previous version of Simply Love, fully delete the old Simply Love folder first.  **Do not merge the new folder into the old.**

You can download the current Simply Love release at the [Latest Release](https://github.com/Simply-Love/Simply-Love-SM5/releases/latest) page.

Full install instructions are in the [Installing Simply Love](./Other/Documentation/InstallingSimplyLove-README.md) README.


## Language Support

Simply Love has support for:

  * English
  * Deutsch
  * Español
  * Français
  * Italiano
  * 日本語
  * Polski
  * Português Brasileiro (incomplete, translator wanted)

The current language can be changed in Simply Love under *System Options*.


## Aspect Ratio Support

Simply Love is designed to be usable at resolutions as low as 640x480 but still look crisp and clean in HD, 2k, 4k, etc.  It supports many screen aspect ratios:

  * <strong>16:9</strong> (common)
  * <strong>16:10</strong> (Apple laptops, some LCD monitors)
  * <strong>4:3</strong> (CRT arcade monitors, older TVs)
  * <strong>21:9</strong> ("Ultrawide")

The aspect ratio can be changed under *Graphics / Sound Options*.


## Screenshots

![Title Screen](https://i.imgur.com/txGZj2Ul.png)
![Gameplay](https://i.imgur.com/6PRBIHil.png)
![twenty-one nine gameplay](https://i.imgur.com/rl6WibDl.png)
![Player Options](https://i.imgur.com/Jk5A4LTl.png)
![Evaluation](https://i.imgur.com/VamMT1Ql.png)
![Select Profile](https://i.imgur.com/1SsDc90l.png)
![Visual Themes](https://i.imgur.com/AQeRafLl.png)

Check out this imgur album for more screenshots: [http://imgur.com/a/56wDq](http://imgur.com/a/56wDq)


---

# Guides

### Installing Simply Love

[Installing Simply Love](./Other/Documentation/InstallingSimplyLove-README.md)

### Profile Avatars

[Profile Avatars](./Other/Documentation/ProfileAvatars-README.md)

### Custom Songs from USB

[Custom Songs from USB](./Other/Documentation/CustomSongsFromUSB-README.md)

### Casual Mode

<p>Casual Mode was designed with public arcade machines and casual players in mind. Learn more here:</p>

[Casual Mode](./Other/Documentation/CasualMode-README.md)

### Tips for installing StepMania

[Troubleshooting StepMania](./Other/Documentation/TroubleshootingStepMania-README.md)


## Hardware Guides

### Buying a 4-Panel Dance Pad

*Dom ITG* has an excellent summary of 4-panel dance pad available in 2020:<br/>
https://www.youtube.com/watch?v=sEWj2_BNG_0

### USB Polling Issues

[USB Polling Issues](./Other/Documentation/USBPollingIssues-README.md)

### Linux for a Dedicated SM5 PC

<p>
  din maintains a Linux image for running SM5 on common arcade hardware:<br/>
  https://dinsfire.com/itgimage
</p>

<p>
  It streamlines the setup process for those who have arcade hardware and
  want to start playing as quickly as possible.
</p>
